/*****************************************************************************
*  LPC8xx SCT demo program
*
*  Use SCT timer capture and capture control features. It implements a
*  PWM decoder which measures the duty cycle of a PWM signal and determines
*  whether it is above (max_width) or below (min_width) a specific value.
*  The PWM signal frequency is assumed to be 10 kHz. Two output signals
*  (width_error and timeout) are included to indicate when the 10 kHz signal
*  has an error or is missing.
*****************************************************************************/
#include "LPC8xx.h"

extern void SCT_Init(void);

void SCT_IRQHandler(void)
{
  uint32_t status = LPC_SCT->EVFLAG;

    if (status & 1)                                    // EVENT 0: timeout
    {
		/* New measurement result */
		;
    }

    if (status & (1 << 5))                             // EVENT 5: width error
    {
		/* Time-out (no signal) */
		;
    }
    LPC_SCT->EVFLAG = status;                          // Acknowledge interrupts
}

int main (void)
{
  volatile static int i = 0;                           // force counter to be placed into memory

    LPC_SYSCON->SYSAHBCLKCTRL |= (1 << 7)              // enable clock to SWM
                               | (1 << 8);             // enable the SCT clock

    LPC_SWM->PINASSIGN5 = 0x06FFFFFF;                  // SCT_IN0  at P0_6 = PWM signal input
    LPC_SWM->PINASSIGN6 = 0x07FFFFFF;                  // SCT_OUT0 at P0_7 = timeout (red LED)
    LPC_SWM->PINASSIGN7 = 0xFFFFFF08;                  // SCT_OUT1 at P0_8 = width_error (green LED)

    SCT_Init();                                        // Initialize SCT0

    while (1)                                          // loop forever
    {
       	/* The settings are chosen in % of duty cycle (assuming a PWM frequency of 10 kHz).
       	 * (In a real world application you want to select better resolution!)
       	 */
        i = LPC_SCT->CAP[4].U;
    }
}
